/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import waba.io.ByteArrayStream;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.NativeMethods;
import waba.io.SerialPort;
import waba.io.Socket;
import waba.io.Stream;
import waba.sys.Convert;
import waba.sys.Vm;
import waba.util.Hashtable;
import waba.util.Vector;

public class NativeMethods4JDK
extends NativeMethods {
    private static String portDEFAULT;
    private static String portIRCOMM;
    private static String portSIR;
    private static String portUSB;
    static Hashtable _dbHash;

    void serialPortCreate(SerialPort serialPort, int n, int n2, int n3, boolean bl, int n4) {
        try {
            System.out.println("NOTE: IN ORDER TO USE THE SERIAL PORT IN JDK, PLEASE");
            System.out.println("OPEN THE FILE superwaba/classes/waba/io/NativeMethods4JDK.java");
            System.out.println("AND UNCOMMENT THE PLACES THAT HAVE !!!. THIS IS NECESSARY TO AVOID THAT");
            System.out.println("ALL USERS MUST HAVE THE COMM.JAR FILE IN THEIR SYSTEMS");
            System.out.println("REMEMBER ALSO TO ADD /superwaba/apps/xplat/commapi/COMM.JAR");
            System.out.println("TO YOUR CLASSPATH");
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("Cannot find javax.comm.CommPortIdentifier. You must add the /superwaba/ext/xplat/wgl/commapi/comm.jar file to your classpath. If you're not using Windows, then you must download the respective Comm api at http://java.sun.com/products/javacomm/");
            serialPort.thisSerialPort = null;
            serialPort.lastError = 65525;
            return;
        }
        catch (Throwable throwable) {
            System.out.println("Exception when creating serial port: " + throwable.toString());
            serialPort.lastError = 771;
            return;
        }
    }

    private static void initSwserial() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("swserial");
            portDEFAULT = resourceBundle.getString("DEFAULT");
            portIRCOMM = resourceBundle.getString("IRCOMM");
            portSIR = resourceBundle.getString("SIR");
            portUSB = resourceBundle.getString("USB");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal Error: missing resource bundle: " + missingResourceException.getClassName());
        }
    }

    private String getPortName(int n) {
        if (portDEFAULT == null) {
            NativeMethods4JDK.initSwserial();
        }
        switch (n) {
            case 0: {
                return portDEFAULT;
            }
            case 4096: {
                return portIRCOMM;
            }
            case 4097: {
                return portSIR;
            }
            case 4098: {
                return portUSB;
            }
        }
        return null;
    }

    boolean serialPortClose(SerialPort serialPort) {
        try {
            return true;
        }
        catch (Throwable throwable) {
            serialPort.lastError = 65525;
            return false;
        }
    }

    boolean serialPortIsOpen(SerialPort serialPort) {
        return serialPort.thisSerialPort != null;
    }

    boolean serialPortSetFlowControl(SerialPort serialPort, boolean bl) {
        try {
            return true;
        }
        catch (Throwable throwable) {
            serialPort.lastError = 778;
            return false;
        }
    }

    boolean serialPortSetReadTimeout(SerialPort serialPort, int n) {
        try {
            return true;
        }
        catch (Throwable throwable) {
            serialPort.lastError = 778;
            return false;
        }
    }

    int serialPortReadBytes(SerialPort serialPort, byte[] byArray, int n, int n2) {
        try {
            return ((InputStream)serialPort.thisInputStream).read(byArray, n, n2);
        }
        catch (IOException iOException) {
            serialPort.lastError = 774;
            iOException.printStackTrace();
            return -1;
        }
        catch (Throwable throwable) {
            serialPort.lastError = 778;
            return -1;
        }
    }

    int serialPortReadCheck(SerialPort serialPort) {
        try {
            return ((InputStream)serialPort.thisInputStream).available();
        }
        catch (IOException iOException) {
            serialPort.lastError = 774;
            iOException.printStackTrace();
            return -1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    int serialPortWriteBytes(SerialPort serialPort, byte[] byArray, int n, int n2) {
        try {
            ((OutputStream)serialPort.thisOutputStream).write(byArray, n, n2);
            return n2;
        }
        catch (IOException iOException) {
            serialPort.lastError = 774;
            iOException.printStackTrace();
            return -1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    void socketCreate(Socket socket, String string, int n, int n2) {
        socket._isOpen = false;
        try {
            socket._socket = new java.net.Socket(string, n);
            ((java.net.Socket)socket._socket).setSoTimeout(n2);
            socket._in = ((java.net.Socket)socket._socket).getInputStream();
            socket._out = ((java.net.Socket)socket._socket).getOutputStream();
            socket._isOpen = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!socket._isOpen && socket._socket != null) {
            try {
                ((java.net.Socket)socket._socket).close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    boolean socketClose(Socket socket) {
        if (!socket._isOpen) {
            return false;
        }
        socket._isOpen = false;
        boolean bl = true;
        try {
            ((java.net.Socket)socket._socket).close();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    boolean socketIsOpen(Socket socket) {
        return socket._isOpen;
    }

    boolean socketSetReadTimeout(Socket socket, int n) {
        if (n < 0) {
            return false;
        }
        if (n == 0) {
            n = 1;
        }
        try {
            ((java.net.Socket)socket._socket).setSoTimeout(n);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    int socketReadBytes(Socket socket, byte[] byArray, int n, int n2) {
        if (!socket._isOpen) {
            return -1;
        }
        int n3 = -1;
        try {
            n3 = ((InputStream)socket._in).read(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    int socketWriteBytes(Socket socket, byte[] byArray, int n, int n2) {
        if (!socket._isOpen) {
            return -1;
        }
        int n3 = -1;
        try {
            ((OutputStream)socket._out).write(byArray, n, n2);
            n3 = n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    boolean socketDisconnect() {
        System.out.println("Not implemented in this platform");
        return true;
    }

    static final CatalogBag getCB(Catalog catalog) {
        return (CatalogBag)catalog.bag;
    }

    CatalogBag createCB() {
        return new CatalogBag();
    }

    static String getFileName(CatalogBag catalogBag) {
        return String.valueOf(catalogBag._name) + ".pdb";
    }

    void catalogCreate(Catalog catalog) {
        catalog.bag = ((NativeMethods4JDK)NativeMethods.nm).createCB();
        NativeMethods4JDK.getCB(catalog).doSetDate();
    }

    void catalogCreate(Catalog catalog, String string, int n) {
        catalog.bag = ((NativeMethods4JDK)NativeMethods.nm).createCB();
        CatalogBag catalogBag = (CatalogBag)catalog.bag;
        String[] stringArray = Convert.tokenizeString(string, '.');
        if (stringArray == null || stringArray.length != 3) {
            Vm.debug("Invalid catalog name: " + string + ". It must be in the form MyCatalog.CRTR.TYPE (see documentation)");
            return;
        }
        catalogBag._name = stringArray[0];
        catalogBag._creator = stringArray[1];
        catalogBag._type = stringArray[2];
        catalogBag._mode = n;
        byte[] byArray = null;
        if (byArray == null) {
            if (n != 4) {
                return;
            }
            catalogBag.doSetDate();
        } else {
            try {
                catalogBag._records = catalogBag.fromPDB(byArray, catalogBag._creator, catalogBag._type, catalogBag._attrs);
            }
            catch (Exception exception) {
                Vm.debug("EXCEPTION OCCURED WITH '" + string + "' DATABASE");
                exception.printStackTrace();
                return;
            }
        }
        _dbHash.put(string, catalog);
        catalogBag._isOpen = true;
    }

    boolean catalogRename(Catalog catalog, String string) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (!catalogBag._isOpen) {
            return false;
        }
        String[] stringArray = Convert.tokenizeString(string, '.');
        if (stringArray == null || stringArray.length != 3) {
            Vm.debug("Invalid catalog name: " + string + ". It must be in the form MyCatalog.CRTR.TYPE (see documentation)");
            return false;
        }
        String string2 = null;
        if (string2 != null) {
            try {
                File file = new File(string2, NativeMethods4JDK.getFileName(catalogBag));
                if (!file.delete()) {
                    Vm.debug("Cannot delete file phisically on Rename. The file will simply be copied with the new given name.");
                }
            }
            catch (Exception exception) {}
        }
        catalogBag._name = stringArray[0];
        catalogBag._creator = stringArray[1];
        catalogBag._type = stringArray[2];
        return true;
    }

    int catalogAddRecord(Catalog catalog, int n) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (!catalogBag._isOpen) {
            return -1;
        }
        catalogBag._recordPos = catalogBag._records.size();
        catalogBag._records.addElement(new byte[n]);
        catalogBag._attrs.addElement(new Byte(64));
        catalogBag._cursor = 0;
        ++catalogBag.modificationNumber;
        return catalogBag._recordPos;
    }

    int catalogAddRecord(Catalog catalog, int n, int n2) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (!catalogBag._isOpen || n < 0) {
            return -1;
        }
        if (n2 > catalogBag._records.size()) {
            Vm.debug("Trying to add a record at an invalid position (" + n2 + " > db size + 1).");
            n2 = catalogBag._records.size();
        }
        try {
            catalogBag._records.insertElementAt(new byte[n], n2);
            catalogBag._attrs.insertElementAt(new Byte(64), n2);
            ++catalogBag.modificationNumber;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
        catalogBag._recordPos = n2;
        catalogBag._cursor = 0;
        return catalogBag._recordPos;
    }

    boolean catalogResizeRecord(Catalog catalog, int n) {
        byte[] byArray;
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (catalogBag._recordPos == -1) {
            return false;
        }
        byte[] byArray2 = (byte[])catalogBag._records.elementAt(catalogBag._recordPos);
        int n2 = byArray2.length < (byArray = new byte[n]).length ? byArray2.length : byArray.length;
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        catalogBag._records.setElementAt(byArray, catalogBag._recordPos);
        ++catalogBag.modificationNumber;
        return true;
    }

    boolean catalogClose(CatalogBag catalogBag) {
        boolean bl = true;
        if (!catalogBag._isOpen) {
            return false;
        }
        if (catalogBag.modificationNumber != catalogBag.originalModificationNumber) {
            try {
                ByteArrayStream byteArrayStream = new ByteArrayStream(2048);
                catalogBag.toPDB(byteArrayStream, catalogBag._records, catalogBag._creator, catalogBag._name, catalogBag._type, catalogBag._attrs);
                FileOutputStream fileOutputStream = null;
                fileOutputStream = new FileOutputStream(NativeMethods4JDK.getFileName(catalogBag));
                if (fileOutputStream == null) {
                    bl = false;
                } else {
                    fileOutputStream.write(byteArrayStream.getBuffer(), 0, byteArrayStream.count());
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        catalogBag._isOpen = false;
        catalogBag._recordPos = -1;
        return bl;
    }

    boolean catalogClose(Catalog catalog) {
        return this.catalogClose(NativeMethods4JDK.getCB(catalog));
    }

    boolean catalogDelete(Catalog catalog) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (!catalogBag._isOpen) {
            return false;
        }
        _dbHash.remove(catalogBag._name);
        catalogBag._records.clear();
        catalogBag._attrs.clear();
        catalogBag._isOpen = false;
        catalogBag._recordPos = -1;
        try {
            ByteArrayStream byteArrayStream;
            try {
                byteArrayStream = null;
                if (byteArrayStream != null) {
                    File file = new File((String)((Object)byteArrayStream), NativeMethods4JDK.getFileName(catalogBag));
                    Vm.debug(file.toString());
                    if (file.delete()) {
                        return true;
                    }
                    Vm.debug("Cannot delete file phisically. Removing logically...");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            byteArrayStream = new ByteArrayStream(1024);
            catalogBag.toPDB(byteArrayStream, catalogBag._records, catalogBag._creator, catalogBag._name, catalogBag._type, catalogBag._attrs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    String[] catalogListCatalogs() {
        Vector vector = new Vector(_dbHash.getKeys().toObjectArray());
        File file = new File(".");
        String[] stringArray = file.list();
        byte[] byArray = new byte[68];
        int n = 0;
        while (n < stringArray.length) {
            if (vector.find(stringArray[n]) == -1 && (stringArray[n].toLowerCase().endsWith("prc") || stringArray[n].toLowerCase().endsWith("pdb"))) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(".", stringArray[n]));
                    fileInputStream.read(byArray);
                    String string = "" + (char)byArray[60] + (char)byArray[61] + (char)byArray[62] + (char)byArray[63];
                    String string2 = "" + (char)byArray[64] + (char)byArray[65] + (char)byArray[66] + (char)byArray[67];
                    String string3 = String.valueOf(stringArray[n].substring(0, stringArray[n].indexOf(46))) + '.' + string2 + '.' + string;
                    if (vector.find(string3) == -1) {
                        vector.add(string3);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error in Catalog.listCatalogs while reading " + stringArray[n]);
                    iOException.printStackTrace();
                }
            }
            ++n;
        }
        return (String[])vector.toObjectArray();
    }

    boolean catalogDeleteRecord(Catalog catalog) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (catalogBag._recordPos == -1) {
            return false;
        }
        catalogBag._records.removeElementAt(catalogBag._recordPos);
        catalogBag._attrs.removeElementAt(catalogBag._recordPos);
        catalogBag._recordPos = -1;
        ++catalogBag.modificationNumber;
        return true;
    }

    int catalogGetRecordCount(Catalog catalog) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (!catalogBag._isOpen) {
            return -1;
        }
        return catalogBag._records.size();
    }

    int catalogGetRecordSize(Catalog catalog) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (catalogBag._recordPos == -1) {
            return -1;
        }
        byte[] byArray = (byte[])catalogBag._records.elementAt(catalogBag._recordPos);
        return byArray.length;
    }

    boolean catalogIsOpen(Catalog catalog) {
        return NativeMethods4JDK.getCB((Catalog)catalog)._isOpen;
    }

    boolean catalogSetRecordPos(Catalog catalog, int n) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (n < 0 || n >= catalogBag._records.size()) {
            catalogBag._recordPos = -1;
            return false;
        }
        if (catalogBag._attrs != null && ((Byte)catalogBag._attrs.elementAt(n) & 0xFFFFFF80) != 0) {
            Vm.debug("You cannot setRecordPos in a deleted record");
            return false;
        }
        catalogBag._recordPos = n;
        catalogBag._cursor = 0;
        return true;
    }

    int _readWriteBytes(Catalog catalog, byte[] byArray, int n, int n2, boolean bl) {
        byte[] byArray2 = null;
        try {
            CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
            if (catalogBag._recordPos == -1 || n < 0 || n2 < 0 || n + n2 > byArray.length) {
                return -1;
            }
            if (catalogBag._mode == 1 && !bl || catalogBag._mode == 2 && bl) {
                Vm.debug("Invalid operation at catalog for this mode");
                return -1;
            }
            if (catalogBag._recordPos >= catalogBag._records.size()) {
                Vm.debug("Record not correctly added. RecordPos: " + catalogBag._recordPos + " but RecordCount: " + catalogBag._records.size());
                return -1;
            }
            byArray2 = (byte[])catalogBag._records.elementAt(catalogBag._recordPos);
            if (catalogBag._cursor + n2 > byArray2.length) {
                return -1;
            }
            if (bl) {
                System.arraycopy(byArray2, catalogBag._cursor, byArray, n, n2);
            } else {
                System.arraycopy(byArray, n, byArray2, catalogBag._cursor, n2);
                if (catalogBag._attrs != null) {
                    this.catalogSetRecordAttributes(catalog, (byte)(this.catalogGetRecordAttributes(catalog) | 0x40));
                }
                ++catalogBag.modificationNumber;
            }
            catalogBag._cursor += n2;
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception + " in _readWriteBytes: rec.length: " + (byArray2 == null ? "null" : String.valueOf(byArray2.length)) + ", buf.length: " + byArray.length + ", start: " + n + ", count: " + n2 + ", isRead? " + bl);
            n2 = -1;
        }
        return n2;
    }

    int catalogReadBytes(Catalog catalog, byte[] byArray, int n, int n2) {
        return this._readWriteBytes(catalog, byArray, n, n2, true);
    }

    int catalogSkipBytes(Catalog catalog, int n) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (catalogBag._recordPos == -1) {
            return -1;
        }
        byte[] byArray = (byte[])catalogBag._records.elementAt(catalogBag._recordPos);
        int n2 = catalogBag._cursor + n;
        if (n2 < 0 || n2 > byArray.length) {
            return -1;
        }
        catalogBag._cursor += n;
        return n;
    }

    int catalogWriteBytes(Catalog catalog, byte[] byArray, int n, int n2) {
        return this._readWriteBytes(catalog, byArray, n, n2, false);
    }

    int catalogInspectRecord(Catalog catalog, byte[] byArray, int n) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        byte[] byArray2 = (byte[])catalogBag._records.elementAt(n);
        int n2 = Math.min(byArray.length, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return n2;
    }

    byte catalogGetRecordAttributes(Catalog catalog) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (catalogBag._recordPos == -1 || catalogBag._attrs == null || catalogBag._recordPos >= catalogBag._attrs.size()) {
            return 0;
        }
        Byte by = (Byte)catalogBag._attrs.elementAt(catalogBag._recordPos);
        return (byte)(by | 0x20);
    }

    void catalogSetRecordAttributes(Catalog catalog, byte by) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        if (catalogBag._recordPos == -1 || catalogBag._attrs == null || catalogBag._recordPos >= catalogBag._attrs.size()) {
            Vm.debug("could not change record attributes");
            return;
        }
        catalogBag._attrs.setElementAt(new Byte(by), catalogBag._recordPos);
        ++catalogBag.modificationNumber;
    }

    int catalogGetAttributes(Catalog catalog) {
        return NativeMethods4JDK.getCB((Catalog)catalog).attributes;
    }

    void catalogSetAttributes(Catalog catalog, int n) {
        CatalogBag catalogBag = NativeMethods4JDK.getCB(catalog);
        catalogBag.attributes = (short)n;
        ++catalogBag.modificationNumber;
    }

    int catalogGetRecordPos(Catalog catalog) {
        return NativeMethods4JDK.getCB((Catalog)catalog)._recordPos;
    }

    static {
        _dbHash = new Hashtable(10);
    }

    class CatalogBag {
        boolean _isOpen;
        String _name;
        int _mode;
        Vector _records = new Vector();
        Vector _attrs = new Vector();
        int _recordPos;
        int _cursor;
        String _creator;
        String _type;
        int originalModificationNumber;
        byte[] appInfoBlock;
        byte[] sortInfoBlock;
        int creationDate;
        int modificationDate;
        int lastBackupDate;
        int modificationNumber;
        short attributes;
        short version = 1;
        int appInfoOffset;
        int sortInfoOffset;
        int uniqueIDSeed;
        int nextRecordListID;

        private long getNow() {
            long l = new Date().getTime() / 1000L;
            return l += 2082844800L;
        }

        private void doSetDate() {
            long l = this.getNow();
            this.modificationDate = this.creationDate = (int)l;
            this.lastBackupDate = (int)(l -= 31536000L);
        }

        public void toPDB(Stream stream, Vector vector, String string, String string2, String string3, Vector vector2) throws Exception {
            int n;
            byte[] byArray = new byte[32];
            byte[] byArray2 = string3.getBytes();
            byte[] byArray3 = string.getBytes();
            int n2 = -1;
            n2 = string2.lastIndexOf(92);
            if (n2 != -1 || (n2 = string2.lastIndexOf(47)) != -1) {
                string2 = string2.substring(n2 + 1);
            }
            if (string2.length() > 31) {
                string2 = string2.substring(0, 31);
            }
            byte[] byArray4 = string2.getBytes();
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = n3 < byArray4.length ? byArray4[n3] : (byte)0;
                ++n3;
            }
            int n4 = vector.size();
            DataStream dataStream = new DataStream(stream);
            int n5 = 80 + n4 * 8;
            if (this.appInfoBlock != null) {
                this.appInfoOffset = n5;
                n5 += this.appInfoBlock.length;
            }
            if (this.sortInfoBlock != null) {
                this.sortInfoOffset = n5;
                n5 += this.sortInfoBlock.length;
            }
            this.attributes = (short)(this.attributes | 8);
            this.modificationDate = (int)this.getNow();
            dataStream.writeBytes(byArray);
            dataStream.writeShort(this.attributes);
            dataStream.writeShort(this.version);
            dataStream.writeInt(this.creationDate);
            dataStream.writeInt(this.modificationDate);
            dataStream.writeInt(this.lastBackupDate);
            dataStream.writeInt(this.modificationNumber);
            dataStream.writeInt(this.appInfoOffset);
            dataStream.writeInt(this.sortInfoOffset);
            dataStream.writeBytes(byArray2);
            dataStream.writeBytes(byArray3);
            dataStream.writeInt(this.uniqueIDSeed);
            int n6 = 0;
            dataStream.writeInt(n6);
            dataStream.writeShort(n4);
            byte[] byArray5 = new byte[3];
            int n7 = 0;
            while (n7 < n4) {
                dataStream.writeInt(n5);
                if (vector2 == null || n7 >= vector2.size()) {
                    dataStream.writeByte(0);
                } else {
                    dataStream.writeByte((int)((Byte)vector2.elementAt(n7) & 0xFFFFFFDF));
                }
                dataStream.writeBytes(byArray5);
                n = ((byte[])vector.elementAt(n7)).length;
                if (n > 65520) {
                    Vm.debug("CAUTION! RECORD " + n7 + " HAS A SIZE GREATER THAN 65520 AND WILL BE REJECTED BY PALM OS!");
                }
                n5 += n;
                ++n7;
            }
            dataStream.writeShort(0);
            if (this.appInfoBlock != null) {
                dataStream.writeBytes(this.appInfoBlock);
            }
            n = 0;
            while (n < n4) {
                dataStream.writeBytes((byte[])vector.elementAt(n));
                ++n;
            }
            dataStream.close();
        }

        public Vector fromPDB(byte[] byArray, String string, String string2, Vector vector) throws Exception {
            int n;
            DataStream dataStream = new DataStream(new ByteArrayStream(byArray));
            if (byArray.length == 0) {
                throw new Exception("Invalid File with 0 length!");
            }
            byte[] byArray2 = new byte[32];
            byte[] byArray3 = new byte[4];
            byte[] byArray4 = new byte[4];
            dataStream.readBytes(byArray2);
            this.attributes = dataStream.readShort();
            this.version = dataStream.readShort();
            this.creationDate = dataStream.readInt();
            this.modificationDate = dataStream.readInt();
            this.lastBackupDate = dataStream.readInt();
            this.modificationNumber = dataStream.readInt();
            this.appInfoOffset = dataStream.readInt();
            this.sortInfoOffset = dataStream.readInt();
            dataStream.readBytes(byArray3);
            dataStream.readBytes(byArray4);
            this.uniqueIDSeed = dataStream.readInt();
            this.originalModificationNumber = this.modificationNumber;
            if (!string.equals(new String(byArray4)) || !string2.equals(new String(byArray3))) {
                if (byArray.length >= 8 && new String(byArray, 0, 8).trim().equalsIgnoreCase("<HTML>")) {
                    return new Vector();
                }
                throw new Exception("Error: invalid pdb file! creatorId '" + string + "' != '" + new String(byArray4) + "' and/or typeId '" + string2 + "' != '" + new String(byArray3) + "' \n" + new String(byArray));
            }
            this.nextRecordListID = dataStream.readInt();
            if (this.nextRecordListID != 0) {
                throw new Exception("Invalid database file! SuperWaba does not support multiple record or resource lists in a Database!!!");
            }
            int n2 = dataStream.readShort();
            int[] nArray = new int[n2 + 1];
            byte[] byArray5 = new byte[3];
            if (vector != null) {
                vector.clear();
            }
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = dataStream.readInt();
                byte by = dataStream.readByte();
                dataStream.readBytes(byArray5);
                if (vector != null) {
                    vector.addElement(new Byte(by));
                }
                ++n3;
            }
            nArray[n2] = byArray.length;
            dataStream.readShort();
            int n4 = 80 + n2 * 8;
            if (this.appInfoOffset > 0) {
                n = this.sortInfoOffset > 0 ? this.sortInfoOffset - n4 : nArray[0] - n4;
                this.appInfoBlock = new byte[n];
                dataStream.readBytes(this.appInfoBlock);
                n4 += n;
            }
            if (this.sortInfoOffset > 0) {
                n = nArray[0] - n4;
                this.sortInfoBlock = new byte[n];
                dataStream.readBytes(this.sortInfoBlock);
                n4 += n;
            }
            Vector vector2 = new Vector(n2);
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                n5 = nArray[n6 + 1] - nArray[n6];
                if (n5 <= 0) {
                    throw new Exception("Invalid record " + n6 + "! Size <= 0 (" + n5 + ")");
                }
                byte[] byArray6 = new byte[n5];
                dataStream.readBytes(byArray6);
                vector2.addElement(byArray6);
                ++n6;
            }
            dataStream.close();
            return vector2;
        }

        protected void finalize() throws Throwable {
            try {
                if (this._isOpen) {
                    System.out.println("Catalog " + this._name + " being closed by GC...");
                    ((NativeMethods4JDK)NativeMethods.nm).catalogClose(this);
                    return;
                }
            }
            catch (Exception exception) {}
        }

        CatalogBag() {
            NativeMethods4JDK.this = NativeMethods4JDK.this;
        }
    }
}

