/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.Stream;
import waba.sys.Vm;

public final class ByteArrayStream
extends Stream {
    private int pos;
    private byte[] buffer;

    public ByteArrayStream(byte[] byArray) {
        this.buffer = byArray;
        this.pos = 0;
    }

    public ByteArrayStream(int n) {
        this(new byte[n]);
    }

    public boolean close() {
        return true;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int count() {
        return this.pos;
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        Vm.copyArray(this.buffer, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public void reset() {
        this.pos = 0;
    }

    public int writeBytes(byte[] byArray, int n, int n2) {
        if (this.buffer.length < n2 + this.pos) {
            byte[] byArray2 = new byte[(n2 + this.pos) * 12 / 10];
            Vm.copyArray(this.buffer, 0, byArray2, 0, this.pos);
            this.buffer = byArray2;
        }
        Vm.copyArray(byArray, n, this.buffer, this.pos, n2);
        this.pos += n2;
        return n2;
    }
}

