/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.io.DataStream;
import waba.util.IntVector;

public final class IntHashtable {
    public static int INVALID = Integer.MIN_VALUE;
    private Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntHashtable(DataStream dataStream) {
        this.table = new Entry[dataStream.readInt()];
        this.loadFactor = dataStream.readFloat();
        this.threshold = dataStream.readInt();
        int n = dataStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.put(dataStream.readInt(), dataStream.readInt());
            ++n2;
        }
    }

    public IntHashtable(int n) {
        this(n, 0.75f);
    }

    public IntHashtable(int n, float f) {
        if (n <= 0) {
            n = 5;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return INVALID;
    }

    public IntVector getKeys() {
        IntVector intVector = new IntVector(this.size());
        int n = this.table.length;
        Entry entry = null;
        int n2 = 0;
        while (n2 < n) {
            entry = this.table[n2];
            if (entry != null) {
                intVector.add(entry.key);
                while (entry.next != null) {
                    entry = entry.next;
                    intVector.add(entry.key);
                }
            }
            ++n2;
        }
        return intVector;
    }

    public int put(int n, int n2) {
        if (n == INVALID || n2 == INVALID) {
            return INVALID;
        }
        Entry[] entryArray = this.table;
        int n3 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n) {
                int n4 = entry.value;
                entry.value = n2;
                return n4;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, n2);
        }
        Entry entry2 = new Entry();
        entry2.key = n;
        entry2.value = n2;
        entry2.next = entryArray[n3];
        entryArray[n3] = entry2;
        ++this.count;
        return INVALID;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = ((n << 1) + n >> 1) + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public int remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.key == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return INVALID;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return "This inthashtable has: " + this.count + " elements and threshold of " + this.threshold;
    }

    public void saveTo(DataStream dataStream) {
        dataStream.writeInt(this.table.length);
        dataStream.writeFloat(this.loadFactor);
        dataStream.writeInt(this.threshold);
        dataStream.writeInt(this.count);
        int n = this.table.length;
        Entry entry = null;
        int n2 = 0;
        while (n2 < n) {
            entry = this.table[n2];
            if (entry != null) {
                dataStream.writeInt(entry.key);
                dataStream.writeInt(entry.value);
                while (entry.next != null) {
                    entry = entry.next;
                    dataStream.writeInt(entry.key);
                    dataStream.writeInt(entry.value);
                }
            }
            ++n2;
        }
    }

    class Entry {
        int key;
        int value;
        Entry next;

        Entry() {
            IntHashtable.this = IntHashtable.this;
        }
    }
}

