/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.Catalog;
import waba.io.Stream;

public class ResizeStream
extends Stream {
    private Catalog cat;
    private int initialSize;
    private int written;
    private int size;

    public ResizeStream(Catalog catalog, int n) {
        this.cat = catalog;
        this.initialSize = n;
    }

    public boolean startRecord(int n) {
        boolean bl = n >= this.cat.getRecordCount() ? this.cat.addRecord(this.initialSize) != -1 : this.cat.addRecord(this.initialSize, n) != -1;
        this.written = 0;
        this.size = this.initialSize;
        return bl;
    }

    public boolean startRecord() {
        boolean bl = this.cat.addRecord(this.initialSize) != -1;
        this.written = 0;
        this.size = this.initialSize;
        return bl;
    }

    public boolean restartRecord(int n) {
        if (n < 0 || n >= this.cat.getRecordCount()) {
            return this.startRecord();
        }
        this.written = 0;
        this.size = this.initialSize;
        if (this.cat.setRecordPos(n)) {
            this.size = this.cat.getRecordSize();
            return true;
        }
        return false;
    }

    public void endRecord() {
        this.cat.resizeRecord(this.written);
        this.size = 0;
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        return this.cat.readBytes(byArray, n, n2);
    }

    public int writeBytes(byte[] byArray, int n, int n2) {
        if (this.size == 0) {
            return this.cat.writeBytes(byArray, n, n2);
        }
        if (n2 - n <= 0) {
            return 0;
        }
        int n3 = this.written + (n2 - n);
        while (n3 > this.size) {
            this.size += this.initialSize;
            if (this.cat.resizeRecord(this.size)) continue;
            return -1;
        }
        int n4 = this.cat.writeBytes(byArray, n, n2);
        if (n4 >= 0) {
            this.written += n4;
        }
        return n4;
    }

    public boolean close() {
        return this.cat.close();
    }
}

