/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;

class InteractivDlg
extends Dialog {
    DevIO dIO;
    FGen fg;
    boolean deviceOK = false;
    double dfreqStep;
    double minFreqStep;
    double dfreq;
    double dpulseStep;
    double minPulseStep;
    double dpulse;
    double dpulseDuty = 50.0;
    double dpulseDutyStep = 0.39;
    double dduty = 50.0;
    GridBagLayout thisGB = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();
    Scrollbar freqBar = new Scrollbar(0);
    Scrollbar dutyBar = new Scrollbar(0);
    Scrollbar pulseBar = new Scrollbar(0);
    Scrollbar pulseDutyBar = new Scrollbar(0);
    Label freqLabel = new Label("Frequency(HZ):");
    Label dutyLabel = new Label("Duty Cycle(%):");
    Label pulseLabel = new Label("Pulse Frequency(HZ):");
    Label pulseDutyLabel = new Label("Pulse Duty(%):");
    Label freqStepLabel = new Label("Step(HZ):");
    Label pulseStepLabel = new Label("Step(HZ):");
    TextField freqStep = new TextField();
    TextField pulseStep = new TextField();
    TextField freq = new TextField();
    TextField pulse = new TextField();
    TextField duty = new TextField();
    TextField pulseDuty = new TextField();
    Button closeButton = new Button(" Close ");
    Panel buttonPanel = new Panel(new FlowLayout(1));
    Panel ctrlPanel = new Panel();

    InteractivDlg(Frame frame, DevIO devIO) {
        super(frame, "Interactive Control", true);
        this.dIO = devIO;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLayout(this.thisGB);
        ((Component)this).setSize(new Dimension(600, 200));
        ((Component)this).setLocation(dimension.width / 2 - 225, dimension.height / 2 - 100);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(10, 2, 2, 2);
        this.thisGB.setConstraints(this.freqLabel, this.c);
        this.add(this.freqLabel);
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.freq, this.c);
        this.add(this.freq);
        this.c.gridx = 2;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 2;
        this.thisGB.setConstraints(this.freqBar, this.c);
        this.add(this.freqBar);
        this.c.gridx = 4;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 1;
        this.thisGB.setConstraints(this.freqStepLabel, this.c);
        this.add(this.freqStepLabel);
        this.c.gridx = 5;
        this.c.gridy = 0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.freqStep, this.c);
        this.add(this.freqStep);
        this.c.insets = new Insets(2, 2, 2, 2);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.dutyLabel, this.c);
        this.add(this.dutyLabel);
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.duty, this.c);
        this.add(this.duty);
        this.c.gridx = 2;
        this.c.gridy = 1;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 2;
        this.thisGB.setConstraints(this.dutyBar, this.c);
        this.add(this.dutyBar);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.c.anchor = 17;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.pulseLabel, this.c);
        this.add(this.pulseLabel);
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.pulse, this.c);
        this.add(this.pulse);
        this.c.gridx = 2;
        this.c.gridy = 2;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 2;
        this.thisGB.setConstraints(this.pulseBar, this.c);
        this.add(this.pulseBar);
        this.c.gridx = 4;
        this.c.gridy = 2;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 1;
        this.thisGB.setConstraints(this.pulseStepLabel, this.c);
        this.add(this.pulseStepLabel);
        this.c.gridx = 5;
        this.c.gridy = 2;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.pulseStep, this.c);
        this.add(this.pulseStep);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.pulseDutyLabel, this.c);
        this.add(this.pulseDutyLabel);
        this.c.gridx = 1;
        this.c.gridy = 3;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.thisGB.setConstraints(this.pulseDuty, this.c);
        this.add(this.pulseDuty);
        this.c.gridx = 2;
        this.c.gridy = 3;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 100.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 2;
        this.thisGB.setConstraints(this.pulseDutyBar, this.c);
        this.add(this.pulseDutyBar);
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.fill = 1;
        this.c.anchor = 15;
        this.c.gridwidth = 0;
        this.c.gridheight = 2;
        this.c.insets = new Insets(10, 10, 10, 10);
        this.thisGB.setConstraints(this.buttonPanel, this.c);
        this.buttonPanel.add(this.closeButton);
        this.add(this.buttonPanel);
        this.fg = new FGen(this.dIO, null, " ");
        this.deviceOK = this.fg.setXtal();
        if (!this.deviceOK) {
            new ErrorMsg("Can't find device!", "Check cable connection and software properties", new MessageDialog(frame, "Error", " ", " "));
        }
        if (this.deviceOK) {
            this.fg.setDuty(50.0);
            this.fg.pulseLow();
        }
        this.minFreqStep = this.fg.xtal / this.fg.Nw;
        this.minPulseStep = this.fg.pXtal / this.fg.nw;
        ((TextComponent)this.freq).setText("0.0");
        ((TextComponent)this.pulse).setText("0.0");
        ((TextComponent)this.pulseStep).setText("0.05");
        ((TextComponent)this.duty).setText("50.0");
        ((TextComponent)this.pulseDuty).setText("50.0");
        this.dfreqStep = this.minFreqStep;
        this.dfreqStep = (double)Math.round(this.dfreqStep * 1000.0) / 1000.0;
        ((TextComponent)this.freqStep).setText(String.valueOf(this.dfreqStep));
        this.freqBar.setValues(0, 1, 0, (int)(this.fg.maxFreq / this.dfreqStep));
        this.freqBar.setUnitIncrement(1);
        this.dpulseStep = this.minPulseStep;
        this.dpulseStep = (double)Math.round(this.dpulseStep * 100.0) / 100.0;
        this.pulseBar.setValues(0, 1, 0, (int)(this.fg.maxPulse / this.dpulseStep));
        this.pulseBar.setUnitIncrement(1);
        this.dutyBar.setValues(50, 1, 1, 98);
        this.dutyBar.setUnitIncrement(1);
        this.pulseDutyBar.setValues(128, 1, 1, 256);
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.closeButton) {
            if (this.deviceOK) {
                this.fg.pulseLow();
            }
            this.dispose();
        } else if (event.target == this.freqBar) {
            if (this.dfreq == 0.0 && this.deviceOK) {
                this.fg.setPulse(this.dpulse, this.dpulseDuty);
            }
            this.dfreq = (double)this.freqBar.getValue() * this.dfreqStep;
            if (this.dfreq == 0.0 && this.deviceOK) {
                this.fg.pulseLow();
            }
            ((TextComponent)this.freq).setText(String.valueOf((double)Math.round(this.dfreq * 1000.0) / 1000.0));
            if (this.deviceOK) {
                this.fg.runFreq(this.dfreq);
            }
        } else if (event.target == this.pulseBar) {
            this.dpulse = (double)this.pulseBar.getValue() * this.dpulseStep;
            ((TextComponent)this.pulse).setText(String.valueOf((double)Math.round(this.dpulse * 100.0) / 100.0));
            if (this.dfreq > 0.0 && this.deviceOK) {
                this.fg.setPulse(this.dpulse, this.dpulseDuty);
            }
        } else if (event.target == this.dutyBar) {
            this.dduty = this.dutyBar.getValue();
            ((TextComponent)this.duty).setText(String.valueOf(this.dduty));
            if (this.deviceOK) {
                this.fg.setDuty(this.dduty);
            }
        } else if (event.target == this.pulseDutyBar) {
            this.dpulseDuty = (double)this.pulseDutyBar.getValue() * this.dpulseDutyStep;
            ((TextComponent)this.pulseDuty).setText(String.valueOf((double)Math.round(this.dpulseDuty * 100.0) / 100.0));
            if (this.deviceOK) {
                this.fg.setPulseDuty(this.dpulseDuty);
            }
        } else if (event.target == this.freq && (event.id == 1005 || event.id == 1001)) {
            double d;
            try {
                d = new Double(this.freq.getText());
            }
            catch (Exception exception) {
                ((TextComponent)this.freq).setText(String.valueOf((double)Math.round(this.dfreq * 1000.0) / 1000.0));
                return true;
            }
            if (d < 0.0 || d > this.fg.maxFreq || d == this.dfreq) {
                ((TextComponent)this.freq).setText(String.valueOf((double)Math.round(this.dfreq * 1000.0) / 1000.0));
                return true;
            }
            if (this.dfreq == 0.0 && this.deviceOK) {
                this.fg.setPulse(this.dpulse, this.dpulseDuty);
            }
            this.dfreq = d;
            if (this.dfreq == 0.0 && this.deviceOK) {
                this.fg.pulseLow();
            }
            ((TextComponent)this.freq).setText(String.valueOf((double)Math.round(this.dfreq * 1000.0) / 1000.0));
            this.freqBar.setValue((int)(this.dfreq / this.dfreqStep));
            if (this.deviceOK) {
                this.fg.runFreq(this.dfreq);
            }
        } else if (event.target == this.pulse && (event.id == 1005 || event.id == 1001)) {
            double d;
            try {
                d = new Double(this.pulse.getText());
            }
            catch (Exception exception) {
                ((TextComponent)this.pulse).setText(String.valueOf((double)Math.round(this.dpulse * 100.0) / 100.0));
                return true;
            }
            if (d < 0.0 || d > this.fg.maxPulse || d == this.dpulse) {
                ((TextComponent)this.pulse).setText(String.valueOf((double)Math.round(this.dpulse * 100.0) / 100.0));
                return true;
            }
            this.dpulse = d;
            ((TextComponent)this.pulse).setText(String.valueOf((double)Math.round(this.dpulse * 100.0) / 100.0));
            this.pulseBar.setValue((int)Math.round(this.dpulse / this.dpulseStep));
            if (this.dfreq > 0.0 && this.deviceOK) {
                this.fg.setPulse(this.dpulse, this.dpulseDuty);
            }
        } else if (event.target == this.duty && (event.id == 1005 || event.id == 1001)) {
            double d;
            try {
                d = new Double(this.duty.getText());
            }
            catch (Exception exception) {
                ((TextComponent)this.duty).setText(String.valueOf((double)Math.round(this.dduty * 100.0) / 100.0));
                return true;
            }
            if (d < 1.0 || d > 97.0 || d == this.dduty) {
                ((TextComponent)this.duty).setText(String.valueOf((double)Math.round(this.dduty * 100.0) / 100.0));
                return true;
            }
            this.dduty = d;
            ((TextComponent)this.duty).setText(String.valueOf((double)Math.round(this.dduty * 100.0) / 100.0));
            this.dutyBar.setValue((int)Math.round(this.dduty));
            if (this.deviceOK) {
                this.fg.setDuty(this.dduty);
            }
        } else if (event.target == this.pulseDuty && (event.id == 1005 || event.id == 1001)) {
            double d;
            try {
                d = new Double(this.pulseDuty.getText());
            }
            catch (Exception exception) {
                ((TextComponent)this.pulseDuty).setText(String.valueOf((double)Math.round(this.dpulseDuty * 100.0) / 100.0));
                return true;
            }
            if (d < 0.5 || d > 99.0 || d == this.dpulseDuty) {
                ((TextComponent)this.pulseDuty).setText(String.valueOf((double)Math.round(this.dpulseDuty * 100.0) / 100.0));
                return true;
            }
            this.dpulseDuty = d;
            ((TextComponent)this.pulseDuty).setText(String.valueOf((double)Math.round(this.dpulseDuty * 100.0) / 100.0));
            this.pulseDutyBar.setValue((int)Math.round(this.dpulseDuty / 100.0 * 256.0));
            if (this.deviceOK) {
                this.fg.setPulseDuty(this.dpulseDuty);
            }
        } else if (event.target == this.freqStep && (event.id == 1005 || event.id == 1001)) {
            double d;
            try {
                d = new Double(this.freqStep.getText());
            }
            catch (Exception exception) {
                ((TextComponent)this.freqStep).setText(String.valueOf((double)Math.round(this.dfreqStep * 1000.0) / 1000.0));
                return true;
            }
            if (d < this.minFreqStep || d > this.fg.maxFreq / 100.0 || d == this.dfreqStep) {
                ((TextComponent)this.freqStep).setText(String.valueOf((double)Math.round(this.dfreqStep * 1000.0) / 1000.0));
                return true;
            }
            this.dfreqStep = d;
            ((TextComponent)this.freqStep).setText(String.valueOf((double)Math.round(this.dfreqStep * 1000.0) / 1000.0));
            this.freqBar.setValues((int)Math.round(this.dfreq / this.dfreqStep), 1, 0, (int)(this.fg.maxFreq / this.dfreqStep));
        } else if (event.target == this.pulseStep && (event.id == 1005 || event.id == 1001)) {
            double d;
            try {
                d = new Double(this.pulseStep.getText());
            }
            catch (Exception exception) {
                ((TextComponent)this.pulseStep).setText(String.valueOf((double)Math.round(this.dpulseStep * 1000.0) / 1000.0));
                return true;
            }
            if (d < this.minPulseStep || d > this.fg.maxPulse / 100.0 || d == this.dpulseStep) {
                ((TextComponent)this.pulseStep).setText(String.valueOf((double)Math.round(this.dpulseStep * 1000.0) / 1000.0));
                return true;
            }
            this.dpulseStep = d;
            ((TextComponent)this.pulseStep).setText(String.valueOf((double)Math.round(this.dpulseStep * 1000.0) / 1000.0));
            this.pulseBar.setValues((int)Math.round(this.dpulse / this.dpulseStep), 1, 0, (int)(this.fg.maxPulse / this.dpulseStep));
        } else {
            return super.handleEvent(event);
        }
        return true;
    }
}

