/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;

public class FGen
extends Thread {
    String prog;
    boolean done = false;
    boolean debug = false;
    boolean hold = false;
    boolean paused = false;
    boolean skip = false;
    RunDialog dlg;
    Frame1 parent;
    double duty = 50.0;
    double pDuty;
    int dwell = 180000;
    double curFreq = -1.0;
    double curDuty = 50.0;
    double curPulse;
    long pauseTime;
    long startFreq;
    long startPause;
    private int displayDelay = 500;
    int N;
    int C = 120;
    int c = 128;
    int device = -1;
    double fuzz;
    double fuzzStep = 0.1;
    double converge;
    double convergeStep = 0.1;
    double freq = 1000.0;
    double pulse;
    double maxPulse = 50000.0;
    double nw = 1.6777216E7;
    public double Nw = 5.36870912E8;
    public double xtal = 5.0E7;
    public double pXtal = 800000.0;
    double nwx = this.nw / this.pXtal;
    double Nwx = this.Nw / this.xtal;
    public double maxFreq = 1500000.0;
    double vDutyM;
    double vDutyB = 50.0;
    double vGateM;
    double vGateB;
    double[] xtals = new double[]{5000000.0, 5.0E7};
    double[] pXtals = new double[]{800000.0};
    StrToken st;
    DevIO sio;
    MessageDialog msgDlg;
    int lc;
    int error;
    Vector progToken;
    Hashtable labels;

    public FGen(DevIO devIO, Frame1 frame1, String string) {
        this.parent = frame1;
        if (this.parent != null) {
            this.msgDlg = this.parent.msgDlg;
        }
        this.prog = string;
        this.sio = devIO;
    }

    public void run() {
        this.setXtal();
        this.prog = this.toLowerCase(this.prog);
        this.stripComments();
        boolean bl = true;
        this.labels = new Hashtable();
        this.splitTokens();
        if (this.parseProg(true)) {
            this.reset();
            this.setPriority(5);
            this.duty = 0.0;
            this.runSingle(0.0, 1.0);
            this.duty = 50.0;
            this.pulseHigh();
            bl = this.parseProg(false);
            this.reset();
            this.pulseLow();
            if (this.dlg != null && bl) {
                this.dlg.done(true);
            }
            if (this.dlg != null && !bl) {
                this.dlg.done(false);
            }
        } else if (this.dlg != null) {
            this.dlg.done(false);
        }
        if (this.parent != null) {
            this.parent.playButton.setEnabled(true);
            this.parent.runMenu.setEnabled(true);
            this.parent.stopButton.setEnabled(false);
            this.parent.stopMenu.setEnabled(false);
            this.parent.pauseButton.setEnabled(false);
            this.parent.pauseMenu.setEnabled(false);
            this.parent.holdButton.setLabel("   Hold   ");
            this.parent.holdMenu.setLabel("Hold");
            this.parent.holdButton.setEnabled(false);
            this.parent.holdMenu.setEnabled(false);
            this.parent.skipButton.setEnabled(false);
            this.parent.skipMenu.setEnabled(false);
        } else {
            if (this.error != 0) {
                System.exit(this.error);
            }
            if (!bl) {
                System.exit(2);
            }
            System.exit(0);
        }
        this.done = true;
    }

    public boolean pulseLow() {
        int[] nArray = new int[2];
        nArray[0] = 99;
        int[] nArray2 = nArray;
        if (this.sio.writeDevice(nArray2) != 0) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        int[] nArray3 = new int[4];
        nArray3[0] = 110;
        int[] nArray4 = nArray3;
        if (this.sio.writeDevice(nArray4) != 0) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        return true;
    }

    private boolean pulseHigh() {
        int[] nArray = new int[]{99, 1};
        if (this.sio.writeDevice(nArray) != 0) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        int[] nArray2 = new int[4];
        nArray2[0] = 110;
        int[] nArray3 = nArray2;
        if (this.sio.writeDevice(nArray3) != 0) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        return true;
    }

    public boolean reset() {
        if (!this.sio.reset()) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        return true;
    }

    private void splitTokens() {
        if (this.prog == null) {
            return;
        }
        StrToken strToken = new StrToken(this.prog, "\n\r", true);
        this.progToken = new Vector();
        String string = null;
        String string2 = null;
        while (strToken.hasMoreTokens()) {
            string = string2;
            string2 = strToken.nextToken();
            if ((string2.equals("\n") || string2.equals("\r")) && string != null) {
                if (!string.equals("\n") && !string.equals("\r")) continue;
                this.progToken.addElement(string2);
                continue;
            }
            this.progToken.addElement(string2);
        }
    }

    public boolean setPulseDuty(double d) {
        int[] nArray;
        if (d <= 0.0) {
            d = 0.39;
        }
        if (d >= 100.0) {
            d = 99.6;
        }
        if (this.sio.writeDevice(nArray = new int[]{99, (int)Math.round(d * 255.0 / 100.0)}) != 0) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        return true;
    }

    public boolean setPulse(double d, double d2) {
        int[] nArray;
        if (d == 0.0) {
            return this.pulseHigh();
        }
        double d3 = d * (this.nw / this.pXtal);
        int n = (int)Math.round(d * this.nwx);
        if (this.debug) {
            System.err.println("\nn->raw:" + d3 + " rnd:" + n + " hex:" + Integer.toHexString(n) + " frq:" + d3 * this.pXtal / this.nw + " real frq:" + (double)n * this.pXtal / this.nw);
        }
        if (this.sio.writeDevice(nArray = new int[]{110, (n & 0xFF0000) >>> 16, (n & 0xFF00) >>> 8, n & 0xFF}) != 0) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        return this.setPulseDuty(d2);
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseProg(boolean var1_1) {
        if (this.prog == null || this.done) {
            return true;
        }
        if (this.debug) {
            System.out.println(" ");
        }
        this.lc = 0;
        while (this.lc < this.progToken.size() && !this.done) {
            this.st = new StrToken((String)this.progToken.elementAt(this.lc), ", \t\n\r", false);
            ++this.lc;
            while (this.st.hasMoreTokens() && !this.done) {
                block97: {
                    var2_2 = this.st.nextToken(", \t\n\r");
                    if (var2_2.equals("cdwell")) {
                        try {
                            var2_2 = this.st.nextToken(" \t\n\r");
                            var6_6 = new Double(var2_2);
                        }
                        catch (Exception v0) {
                            this.syntaxError("cdwell command syntax error");
                            return false;
                        }
                        if (var6_6 < 1.0 || var6_6 > 2.14748E9) {
                            this.syntaxError("value out of range in cdwell command.");
                            return false;
                        }
                        if (var1_1) continue;
                        this.dwell = (int)(var6_6 * -1.0);
                        continue;
                    }
                    if (var2_2.equals("amplitude")) continue;
                    if (var2_2.equals("converge")) {
                        var6_7 = false;
                        try {
                            var2_2 = this.st.nextToken(" \t");
                            var3_3 = this.st.nextToken(" \t\n\r");
                            if (var2_2.charAt(var2_2.length() - 1) == '%' && var2_2.length() > 1) {
                                var2_2 = var2_2.substring(0, var2_2.length() - 1);
                                var6_7 = true;
                            }
                            var7_18 = new Double(var2_2);
                            var9_20 = new Double(var3_3);
                        }
                        catch (Exception v1) {
                            this.syntaxError("syntax error in converge command");
                            return false;
                        }
                        if (!var6_7 && (var7_18 < 0.0 || var9_20 < 0.0 || var9_20 > var7_18 * 2.0)) {
                            this.syntaxError("value out of range in converge command");
                            return false;
                        }
                        if (var6_7 && (var7_18 < 0.0 || var9_20 < 0.0)) {
                            this.syntaxError("value out of range in converge command");
                            return false;
                        }
                        if (var1_1) continue;
                        if (var7_18 != 0.0) {
                            this.fuzz = 0.0;
                        }
                        this.converge = var6_7 == false ? var7_18 : -var7_18;
                        this.convergeStep = var9_20;
                        continue;
                    }
                    if (var2_2.equals("offset")) continue;
                    if (var2_2.equals("pulse")) {
                        try {
                            var2_2 = this.st.nextToken(" \t");
                            var3_3 = this.st.nextToken(" \t\n\r");
                            var6_8 = new Double(var2_2);
                            var8_19 = new Double(var3_3);
                            if (var8_19 > 100.0 || var8_19 < 0.0 || var6_8 > this.maxPulse || var6_8 < 0.0) {
                                this.syntaxError("value out of range in pulse command");
                                return false;
                            }
                        }
                        catch (Exception v2) {
                            this.syntaxError("pulse command syntax error");
                            return false;
                        }
                        if (var1_1) continue;
                        this.pulse = var6_8;
                        this.pDuty = var8_19;
                        if (this.setPulse(this.pulse, this.pDuty)) continue;
                        return false;
                    }
                    if (var2_2.equals("pause")) {
                        try {
                            var2_2 = this.st.nextToken(" \t\n\r");
                            var6_9 = new Double(var2_2);
                            if (var6_9 < 0.0) {
                                this.syntaxError("value out of range in pause command");
                                return false;
                            }
                        }
                        catch (Exception v3) {
                            this.syntaxError("syntax error in pause command");
                            return false;
                        }
                        if (var1_1) continue;
                        if (var6_9 * 1000.0 >= (double)this.displayDelay && this.dlg == null) {
                            System.out.println("Pause...");
                        }
                        if (!this.pulseLow()) {
                            return false;
                        }
                        try {
                            Thread.sleep((long)(var6_9 * 1000.0));
                        }
                        catch (InterruptedException v4) {
                            this.wasInterrupted();
                        }
                        if (this.setPulse(this.pulse, this.pDuty)) continue;
                        return false;
                    }
                    if (var2_2.equals("dwell")) {
                        try {
                            var2_2 = this.st.nextToken(" \t\n\r");
                            var6_10 = new Double(var2_2);
                        }
                        catch (Exception v5) {
                            this.syntaxError("dwell command syntax error");
                            return false;
                        }
                        if (var6_10 < 0.001 || var6_10 > 2147480.0) {
                            this.syntaxError("value out of range in dwell command.");
                            return false;
                        }
                        if (var1_1) continue;
                        this.dwell = (int)(var6_10 * 1000.0);
                        continue;
                    }
                    if (var2_2.equals("duty")) {
                        try {
                            var2_2 = this.st.nextToken(" \t\n\r");
                            var6_11 = new Double(var2_2);
                        }
                        catch (Exception v6) {
                            this.syntaxError("duty command syntax error");
                            return false;
                        }
                        if (var6_11 < 0.0 || var6_11 > 100.0) {
                            this.syntaxError("value out of range in duty command");
                            return false;
                        }
                        if (var1_1) continue;
                        this.duty = var6_11;
                        this.vDutyM = 0.0;
                        this.vDutyB = this.duty;
                        continue;
                    }
                    if (var2_2.equals("exit")) {
                        if (var1_1) continue;
                        return true;
                    }
                    if (var2_2.equals("vduty")) {
                        try {
                            var2_2 = this.st.nextToken(" \t");
                            var3_3 = this.st.nextToken(" \t");
                            var4_4 = this.st.nextToken(" \t");
                            var5_5 = this.st.nextToken(" \t\n\r");
                            var6_12 = new Double(var2_2);
                            var10_21 = new Double(var3_3);
                            var8_19 = new Double(var4_4);
                            var12_27 = new Double(var5_5);
                        }
                        catch (Exception v7) {
                            this.syntaxError("vduty command syntax error");
                            return false;
                        }
                        if (var6_12 == var8_19) {
                            this.syntaxError("x1=x2 in vduty command");
                            return false;
                        }
                        if (var1_1) continue;
                        this.vDutyM = (var12_27 - var10_21) / (var8_19 - var6_12);
                        this.vDutyB = var10_21 - this.vDutyM * var6_12;
                        if (this.vDutyM != 0.0) continue;
                        this.duty = this.vDutyB;
                        continue;
                    }
                    if (var2_2.equals("vgate") || var2_2.equals("vpulse")) {
                        try {
                            var4_4 = this.st.nextToken(" \t");
                            var3_3 = this.st.nextToken(" \t");
                            var5_5 = this.st.nextToken(" \t\n\r");
                            var6_13 = new Double(var4_4);
                            var8_19 = new Double(var3_3);
                            var10_22 = new Double(var5_5);
                            if (var10_22 > 100.0 || var10_22 < 0.0) {
                                this.syntaxError("value out of range in " + var2_2 + " command");
                                return false;
                            }
                            if (var6_13 == 0.0 && var8_19 > this.maxPulse || var6_13 == 0.0 && var8_19 < 0.0) {
                                this.syntaxError("value out of range in " + var2_2 + " command");
                                return false;
                            }
                        }
                        catch (Exception v8) {
                            this.syntaxError(String.valueOf(var2_2) + " command syntax error");
                            return false;
                        }
                        if (var1_1) continue;
                        this.vGateM = var6_13;
                        this.vGateB = var8_19;
                        this.pDuty = var10_22;
                        if (this.vGateM != 0.0) continue;
                        this.pulse = this.vGateB;
                        if (this.setPulse(this.pulse, this.pDuty)) continue;
                        return false;
                    }
                    if (!var2_2.equals("sweep")) break block97;
                    try {
                        var2_2 = this.st.nextToken(" \t");
                        var3_3 = this.st.nextToken(" \t");
                        var4_4 = this.st.nextToken(" \t\n\r");
                        var6_14 = new Double(var2_2);
                        var8_19 = new Double(var3_3);
                        var10_23 = new Double(var4_4);
                    }
                    catch (Exception v9) {
                        this.syntaxError("syntax error in sweep command");
                        return false;
                    }
                    if (var6_14 < 0.0 || var8_19 < 0.0 || var10_23 <= 0.0) {
                        this.syntaxError("value out of range in sweep command");
                        return false;
                    }
                    if (var1_1) continue;
                    var12_28 = var6_14;
                    if (this.dwell < 500) {
                        if (this.dlg != null) {
                            this.dlg.setLargeMsg((String)this.progToken.elementAt(this.lc - 1));
                        } else {
                            System.out.println("Running: " + this.progToken.elementAt(this.lc - 1));
                        }
                    }
                    if (!(var6_14 <= var8_19)) ** GOTO lbl208
                    while (var12_28 <= var8_19 + 0.001 && !this.done) {
                        if (!this.runSingle(var12_28, this.dwell)) {
                            return false;
                        }
                        var12_28 += var10_23;
                    }
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        if (!this.runSingle(var12_28, this.dwell)) {
                            return false;
                        }
                        var12_28 -= var10_23;
lbl208:
                        // 2 sources

                        ** while (var12_28 >= var8_19 - 0.001 && !this.done)
                    }
lbl209:
                    // 1 sources

                    continue;
                }
                if (var2_2.equals("fuzz")) {
                    var6_15 = false;
                    try {
                        var2_2 = this.st.nextToken(" \t");
                        var3_3 = this.st.nextToken(" \t\n\r");
                        if (var2_2.charAt(var2_2.length() - 1) == '%' && var2_2.length() > 1) {
                            var2_2 = var2_2.substring(0, var2_2.length() - 1);
                            var6_15 = true;
                        }
                        var7_18 = new Double(var2_2);
                        var9_20 = new Double(var3_3);
                    }
                    catch (Exception v10) {
                        this.syntaxError("syntax error in fuzz command");
                        return false;
                    }
                    if (!var6_15 && (var7_18 < 0.0 || var9_20 < 0.0 || var9_20 > var7_18 * 2.0)) {
                        this.syntaxError("value out of range in fuzz command");
                        return false;
                    }
                    if (var6_15 && (var7_18 < 0.0 || var9_20 < 0.0)) {
                        this.syntaxError("value out of range in fuzz command");
                        return false;
                    }
                    if (var1_1) continue;
                    if (var7_18 != 0.0) {
                        this.converge = 0.0;
                    }
                    this.fuzz = var6_15 == false ? var7_18 : -var7_18;
                    this.fuzzStep = var9_20;
                    continue;
                }
                if (var2_2.equals("label")) {
                    try {
                        var2_2 = this.st.nextToken(" \t\n\r");
                    }
                    catch (Exception v11) {
                        this.syntaxError("syntax error in label command");
                        return false;
                    }
                    if (!var1_1) continue;
                    if (var2_2.length() < 1) {
                        this.syntaxError("invalid label in label command");
                        return false;
                    }
                    if (this.labels.get(var2_2) != null) {
                        this.labels.remove(var2_2);
                    }
                    this.labels.put(var2_2, new Integer(this.lc - 1));
                    continue;
                }
                if (var2_2.equals("print")) {
                    try {
                        var2_2 = this.st.nextToken("\n\r");
                    }
                    catch (Exception v12) {
                        this.syntaxError("syntax error in print command");
                        return false;
                    }
                    if (var2_2.length() < 1) {
                        this.syntaxError("invalid string in print command");
                        return false;
                    }
                    if (var1_1) continue;
                    if (this.dlg != null) {
                        this.dlg.setSmallMsg(var2_2);
                        continue;
                    }
                    System.out.println(var2_2);
                    continue;
                }
                if (var2_2.equals("goto")) {
                    try {
                        var2_2 = this.st.nextToken(" \t\n\r");
                    }
                    catch (Exception v13) {
                        this.syntaxError("syntax error in goto command");
                        return false;
                    }
                    if (var2_2.length() < 1) {
                        this.syntaxError("invalid label in goto command");
                        return false;
                    }
                    if (var1_1) continue;
                    var6_16 = (Integer)this.labels.get(var2_2);
                    if (var6_16 == null) {
                        this.syntaxError("label does not exist");
                        return false;
                    }
                    this.lc = var6_16;
                    continue;
                }
                try {
                    var6_17 = new Double(var2_2);
                    if (var6_17 < 0.0) {
                        this.syntaxError("negative frequency");
                        return false;
                    }
                    if (var6_17 > this.maxFreq) {
                        this.syntaxError("Frequency out of range. Maximum is " + this.maxFreq);
                        return false;
                    }
                }
                catch (Exception v14) {
                    this.syntaxError("syntax error");
                    return false;
                }
                if (var1_1) continue;
                if (this.fuzz == 0.0 && this.converge == 0.0) {
                    if (this.runSingle(var6_17, this.dwell)) continue;
                    return false;
                }
                if (this.fuzz != 0.0) {
                    var8_19 = this.fuzz < 0.0 ? var6_17 * (this.fuzz / -100.0) : this.fuzz;
                    var10_24 = var6_17 - var8_19;
                    if (var10_24 < 0.0) {
                        var10_24 = 0.0;
                    }
                    var12_29 = (int)((var6_17 + var8_19 - var10_24) / this.fuzzStep);
                    var13_31 = 0;
                    if (var12_29 != 0) {
                        var13_31 = this.dwell / (var12_29 + 1);
                    }
                    if (var13_31 < 500) {
                        if (this.dlg != null) {
                            this.dlg.setLargeMsg("Fuzz " + this.progToken.elementAt(this.lc - 1));
                        } else {
                            System.out.println("Running fuzz " + this.progToken.elementAt(this.lc - 1));
                        }
                    }
                    while (var10_24 <= var6_17 + var8_19 && !this.done) {
                        if (!this.runSingle(var10_24, var13_31)) {
                            return false;
                        }
                        var10_24 += this.fuzzStep;
                    }
                    continue;
                }
                var8_19 = this.converge < 0.0 ? var6_17 * (this.converge / -100.0) : this.converge;
                var10_25 = (int)Math.round(var8_19 / this.convergeStep);
                var11_26 = 0;
                if (var10_25 != 0) {
                    var11_26 = this.dwell / (var10_25 * 2 + 1);
                }
                var12_30 = var6_17 - var8_19;
                var14_32 = var6_17 + var8_19;
                if (var11_26 < 500) {
                    if (this.dlg != null) {
                        this.dlg.setLargeMsg("Converge " + this.progToken.elementAt(this.lc - 1));
                    } else {
                        System.out.println("Running converge " + this.progToken.elementAt(this.lc - 1));
                    }
                }
                var16_33 = 0;
                while (var16_33 < var10_25 && !this.done) {
                    if (!this.runSingle(var12_30 + (double)var16_33 * this.convergeStep, var11_26)) {
                        return false;
                    }
                    if (!this.runSingle(var14_32 - (double)var16_33 * this.convergeStep, var11_26)) {
                        return false;
                    }
                    ++var16_33;
                }
                if (this.runSingle(var6_17, var11_26)) continue;
                return false;
            }
        }
        return true;
    }

    private void syntaxError(String string) {
        if (this.dlg != null) {
            this.dlg.setSmallMsg("ERROR: " + string + " near line " + this.lc + ":\n   " + this.progToken.elementAt(this.lc - 1));
        } else {
            System.err.println("ERROR: " + string + " near line " + this.lc + ":\n   " + this.progToken.elementAt(this.lc - 1));
        }
        this.error = 1;
    }

    public boolean setDuty(double d) {
        int[] nArray;
        if (d > 96.875) {
            d = 96.875;
        }
        if (d < 3.125) {
            d = 3.125;
        }
        if (this.sio.writeDevice(nArray = new int[]{67, (int)Math.round(d * 31.0 / 100.0)}) != 0) {
            System.err.println("Serial IO error");
            return false;
        }
        return true;
    }

    private boolean runSingle(double d, double d2) {
        int[] nArray;
        this.skip = false;
        if (d < 0.0 || this.done || d > this.maxFreq || this.paused) {
            return true;
        }
        if (d2 < 0.0 && (d2 = d2 / d * -1000.0) < 1.0) {
            d2 = 1.0;
        }
        if (this.vGateM != 0.0) {
            this.pulse = this.vGateM * d + this.vGateB;
            if (this.pulse < 0.0) {
                this.pulse = 0.0;
            }
            if (this.pulse > this.maxPulse) {
                this.pulse = this.maxPulse;
            }
            if (!this.setPulse(this.pulse, this.pDuty)) {
                return false;
            }
        }
        double d3 = this.duty;
        if (this.vDutyM != 0.0) {
            d3 = this.vDutyM * d + this.vDutyB;
        }
        this.setDuty(d3);
        double d4 = 0.0;
        if (this.debug) {
            d4 = d * this.Nwx;
        }
        this.N = (int)Math.round(d * this.Nwx);
        if (this.debug) {
            System.err.println("\ninFreq:" + d + " Nwx:" + this.Nwx + " N----->raw:" + d4 + " rnd:" + this.N + " hex:" + Integer.toHexString(this.N) + " frq:" + d4 * (this.xtal / this.Nw));
        }
        this.curFreq = d;
        this.curDuty = d3;
        this.curPulse = this.pulse;
        this.pauseTime = 0L;
        this.startFreq = System.currentTimeMillis();
        int[] nArray2 = this.device >= 4 ? (nArray = new int[]{78, (this.N & 0xFF000000) >>> 24, (this.N & 0xFF0000) >>> 16, (this.N & 0xFF00) >>> 8, this.N & 0xFF}) : (nArray = new int[]{78, (this.N & 0xFF0000) >>> 16, (this.N & 0xFF00) >>> 8, this.N & 0xFF});
        if (this.sio.writeDevice(nArray2) != 0) {
            new ErrorMsg("F100 Device Output Communication Error", this.msgDlg);
            return false;
        }
        if (d2 >= 500.0) {
            double d5 = (double)Math.round(d * 100.0) / 100.0;
            double d6 = (double)Math.round((double)this.N * this.xtal / this.Nw * 1000.0) / 1000.0;
            if (this.dlg != null) {
                this.dlg.setLargeMsg(String.valueOf(d5) + " (" + d6 + ") HZ");
            } else {
                System.out.println("Running " + d5 + "  (" + d6 + ") HZ");
            }
        }
        d2 -= (double)this.pauseTime;
        this.pauseTime = 0L;
        while (d2 > 0.0 && !this.done) {
            try {
                Thread.sleep((long)d2);
            }
            catch (InterruptedException interruptedException) {
                if (this.skip) {
                    this.skip = false;
                    return true;
                }
                this.wasInterrupted();
            }
            d2 = d2 - (double)(System.currentTimeMillis() - this.startFreq) + (double)this.pauseTime;
        }
        while (this.hold && !this.done) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                if (this.skip) {
                    this.skip = false;
                    return true;
                }
                this.wasInterrupted();
            }
        }
        this.curFreq = 0.0;
        if (d2 >= 500.0 && this.dlg != null) {
            this.dlg.setLargeMsg("Running...");
        }
        return true;
    }

    public boolean runFreq(double d) {
        int[] nArray;
        if (d < 0.0 || d > this.maxFreq) {
            return true;
        }
        this.N = (int)Math.round(d * this.Nwx);
        if (this.device >= 4) {
            int[] nArray2 = new int[]{78, (this.N & 0xFF000000) >>> 24, (this.N & 0xFF0000) >>> 16, (this.N & 0xFF00) >>> 8, this.N & 0xFF};
            nArray = nArray2;
        } else {
            int[] nArray3;
            nArray = nArray3 = new int[]{78, (this.N & 0xFF0000) >>> 16, (this.N & 0xFF00) >>> 8, this.N & 0xFF};
        }
        this.sio.writeDevice(nArray);
        return true;
    }

    private void stripComments() {
        if (this.prog == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.prog.length());
        this.st = new StrToken(this.prog, "#", true);
        while (this.st.hasMoreTokens()) {
            String string = this.st.nextToken("#");
            if (string.compareTo("#") == 0) {
                if (this.st.hasMoreTokens()) {
                    string = this.st.nextToken("\n\r");
                }
                if (!string.equals("\n") && !string.equals("\r")) continue;
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(string);
        }
        this.prog = stringBuffer.toString();
    }

    public void setDlg(RunDialog runDialog) {
        this.dlg = runDialog;
    }

    public boolean setXtal() {
        this.sio.reset();
        boolean bl = true;
        if (!this.sio.readID()) {
            new ErrorMsg("Can't find device!", "Check cable connection and software properties", this.msgDlg);
            bl = false;
        }
        this.xtal = this.sio.X > this.xtals.length || this.sio.X < 0 ? this.xtals[0] : this.xtals[this.sio.X];
        this.pXtal = this.sio.x > this.pXtals.length || this.sio.x < 0 ? this.pXtals[0] : this.pXtals[this.sio.x];
        if (this.debug) {
            System.err.println("Xtals: " + this.xtal + " " + this.pXtal);
        }
        this.device = this.sio.device;
        if (this.debug) {
            System.err.print("\nDevice:" + this.device + "\n");
        }
        this.maxFreq = 1.6777216E7 * (this.xtal / this.Nw);
        if (this.device >= 4) {
            this.Nw = 4.294967296E9;
            this.maxFreq = this.xtal * 0.4;
        }
        this.nwx = this.nw / this.pXtal;
        this.Nwx = this.Nw / this.xtal;
        return bl;
    }

    private String toLowerCase(String string) {
        int n = string.length();
        int n2 = -1;
        int n3 = n - 1;
        while (n3 >= 0) {
            char c = string.charAt(n3);
            if (Character.toLowerCase(c) != c) {
                n2 = n3;
                break;
            }
            --n3;
        }
        if (n2 == -1) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n4 = n2;
        while (n4 >= 0) {
            cArray[n4] = Character.toLowerCase(cArray[n4]);
            --n4;
        }
        return new String(cArray);
    }

    private void wasInterrupted() {
        this.done = true;
        this.reset();
        this.pulseLow();
    }

    public void stopIt() {
        this.done = true;
        this.interrupt();
        this.reset();
        this.reset();
        this.pulseLow();
    }
}

