/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuBarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class MenuBar
extends MenuComponent
implements MenuContainer {
    Vector menus = new Vector();
    Menu helpMenu;
    private static final String base = "menubar";
    private static int nameCounter;
    private static final long serialVersionUID = -4930327919388951260L;
    private int menuBarSerializedDataVersion = 1;

    String constructComponentName() {
        return base + nameCounter++;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
            }
            int n = this.getMenuCount();
            int n2 = 0;
            while (n2 < n) {
                this.getMenu(n2).addNotify();
                ++n2;
            }
            return;
        }
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getMenuCount();
            int n2 = 0;
            while (n2 < n) {
                this.getMenu(n2).removeNotify();
                ++n2;
            }
            super.removeNotify();
            return;
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public void setHelpMenu(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.helpMenu == menu) {
                Object var3_3 = null;
                return;
            }
            if (this.helpMenu != null) {
                this.helpMenu.removeNotify();
                this.helpMenu.parent = null;
            }
            if (menu.parent != this) {
                this.add(menu);
            }
            this.helpMenu = menu;
            if (menu != null) {
                menu.isHelpMenu = true;
                menu.parent = this;
                MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
                if (menuBarPeer != null) {
                    if (menu.peer == null) {
                        menu.addNotify();
                    }
                    menuBarPeer.addHelpMenu(menu);
                }
            }
            return;
        }
    }

    public Menu add(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menu.parent != null) {
                menu.parent.remove(menu);
            }
            this.menus.addElement(menu);
            menu.parent = this;
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                if (menu.peer == null) {
                    menu.addNotify();
                }
                menuBarPeer.addMenu(menu);
            }
            Menu menu2 = menu;
            Object var4_5 = null;
            return menu2;
        }
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                Menu menu = this.getMenu(n);
                menu.removeNotify();
                menu.parent = null;
                menuBarPeer.delMenu(n);
            }
            this.menus.removeElementAt(n);
            return;
        }
    }

    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.menus.indexOf(menuComponent);
            if (n >= 0) {
                this.remove(n);
            }
            return;
        }
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        return this.menus.size();
    }

    public Menu getMenu(int n) {
        return (Menu)this.menus.elementAt(n);
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            Enumeration enumeration = this.getMenu(n2).shortcuts();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            ++n2;
        }
        return vector.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getMenu(n2).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        if (n != 401 && n != 402) {
            return false;
        }
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((keyEvent.getModifiers() & n2) == 0) {
            return false;
        }
        int n3 = this.getMenuCount();
        int n4 = 0;
        while (n4 < n3) {
            Menu menu = this.getMenu(n4);
            if (menu.handleShortcut(keyEvent)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            this.getMenu(n2).deleteShortcut(menuShortcut);
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = 0;
        while (n < this.menus.size()) {
            Menu menu = (Menu)this.menus.elementAt(n);
            menu.parent = this;
            ++n;
        }
    }
}

